/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
struct Object
{
   Matrix matrix; // matrix
   Vec       vel, // linear  velocity
         ang_vel; // angular velocity
}object[12];
/******************************************************************************/
Mesh mbox ,
     mball;
/******************************************************************************/
void InitPre()
{
   App.name="Rendering Motion Blur";
   App.flag=APP_MS_EXCLUSIVE|APP_FULL_TOGGLE;
   PakAdd("../data/engine.pak");

   D.full(true).mtnMode(MTN_HIGH); // enable motion blur
   D.mtnVelScale(0.20);            // increase motion blurring
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=3;

   Material *material=Materials("../data/mtrl/brick/0.mtrl");

   mbox .create(1).B(0).create( Box(  4),VTX_TX0|VTX_NRM|VTX_TNG).reverse(); // create mesh box, reverse it because it's meant to be viewed from inside
   mball.create(1).B(0).create(Ball(0.2),VTX_TX0|VTX_NRM|VTX_TNG)          ; // create mesh ball

   // set mesh materials, rendering versions and bounding boxes
   mbox .setMaterial(material).setRender().setBox();
   mball.setMaterial(material).setRender().setBox();

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   
   CamHandle(0.1,10,CAMH_ZOOM|(Ms.b(1) ? CAMH_MOVE : CAMH_ROT)); // move camera on right mouse button

   // change motion blur mode when keys pressed
   if(Kb.bp(KB_1))D.mtnMode(MTN_NONE);
   if(Kb.bp(KB_2))D.mtnMode(MTN_LOW );
   if(Kb.bp(KB_3))D.mtnMode(MTN_HIGH);

   // update ball object matrixes and calculate velocity changes automatically
   Flt speed=4;
   REPA(object)
   {
      // calculate new matrix
      Vec2   v; SinCos(v.y,v.x, i*PI2/ELMS(object) + Tm.time()*speed); // calculate sine and cosine of angle
      Matrix new_matrix(Vec(v.x,0,v.y));                               // create 'new_matrix' with initial position

      // calculate velocity changes according to old and new matrix
      GetVel(object[i].vel,object[i].ang_vel, object[i].matrix,new_matrix);

      // store new matrix
      object[i].matrix=new_matrix;
   }

   return true;
}
/******************************************************************************/
void Render() // rendering method
{
   switch(Renderer())
   {
      case RM_SOLID:
         mbox.draw(MatrixIdentity,Vec(0,0,0));                                     // box is rendered with identity matrix and (0,0,0) velocity
         REPA(object)mball.draw(object[i].matrix,object[i].vel,object[i].ang_vel); // draw ball objects with their matrix and velocities
      break;

      case RM_LIGHT:
         LightPoint(25,Vec(0,3,0)).add();
      break;
   }
}
void Draw()
{
   Renderer(Render);
   D.text(0,0.9,S+"Fps "+Tm.fps); // show number of fps
   D.text(0,0.8,"Press 1,2,3 keys for different Motion Blur modes");
   switch(D.mtnMode())
   {
      case MTN_NONE: D.text(0,0.7,"No Motion Blur"  ); break;
      case MTN_LOW : D.text(0,0.7,"Camera only"     ); break;
      case MTN_HIGH: D.text(0,0.7,"Camera + Objects"); break;
   }
}
/******************************************************************************/
